#!/bin/bash
# Install script for Genome Renard VST3 plugin

set -e

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
VST3_NAME="genome_renard.vst3"

# Default install locations
USER_VST3_DIR="$HOME/.vst3"
SYSTEM_VST3_DIR="/usr/lib/vst3"

echo "=== Genome Renard VST3 Installer ==="
echo ""
echo "Prerequisites:"
echo "  - Wine (wine-stable or wine-staging)"
echo "  - Windows VST3 plugin installed in Wine:"
echo "    C:\\Program Files\\Common Files\\VST3\\Genome.vst3"
echo ""

# Check Wine
if ! command -v wine &> /dev/null; then
    echo "ERROR: Wine not found. Please install wine first."
    exit 1
fi
echo "✓ Wine found: $(wine --version)"

# Choose install location
echo ""
echo "Install location:"
echo "  1) User (~/.vst3) - no root required"
echo "  2) System (/usr/lib/vst3) - requires sudo"
read -p "Choice [1]: " choice
choice=${choice:-1}

if [ "$choice" = "2" ]; then
    INSTALL_DIR="$SYSTEM_VST3_DIR"
    SUDO="sudo"
else
    INSTALL_DIR="$USER_VST3_DIR"
    SUDO=""
fi

# Install
echo ""
echo "Installing to $INSTALL_DIR..."
$SUDO mkdir -p "$INSTALL_DIR"
$SUDO rm -rf "$INSTALL_DIR/$VST3_NAME"
$SUDO cp -r "$SCRIPT_DIR/$VST3_NAME" "$INSTALL_DIR/"

echo ""
echo "✓ Installed successfully!"
echo ""
echo "Next steps:"
echo "  1. Make sure Genome VST3 is installed in Wine:"
echo "     wine '/path/to/Genome_Installer.exe'"
echo "  2. Scan for new plugins in your DAW"
echo "  3. Look for 'Genome Renard' in your plugin list"
